/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.util.JavaVersion;
import de.javasoft.util.OS;
import java.awt.Insets;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.synth.SynthContext;
import sun.swing.DefaultLookup;
import sun.swing.plaf.synth.SynthUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntheticaDefaultLookup
extends DefaultLookup {
    private static Class<?> synthUI;

    public SyntheticaDefaultLookup() {
        try {
            synthUI = JavaVersion.JAVA5 || JavaVersion.JAVA6 ? Class.forName("sun.swing.plaf.synth.SynthUI") : Class.forName("javax.swing.plaf.synth.SynthUI");
        }
        catch (ClassNotFoundException classNotFoundException) {
            new RuntimeException(classNotFoundException);
        }
    }

    @Override
    public Object getDefault(JComponent jComponent, ComponentUI componentUI, String string) {
        SynthContext synthContext;
        if ("ToggleButton.focusInputMap".equals(string) || "RadioButton.focusInputMap".equals(string) || "CheckBox.focusInputMap".equals(string)) {
            return LookAndFeel.makeInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"});
        }
        if (OS.getCurrentOS() == OS.Mac && this.isSynthUI(componentUI) && SyntheticaLookAndFeel.getBoolean("Synthetica.metaKeySupportOnMacEnabled", jComponent, true) && ("TextField.focusInputMap".equals(string) || "FormattedTextField.focusInputMap".equals(string) || "PasswordField.focusInputMap".equals(string) || "TextArea.focusInputMap".equals(string) || "TextPane.focusInputMap".equals(string) || "EditorPane.focusInputMap".equals(string) || "List.focusInputMap".equals(string) || "Tree.focusInputMap".equals(string) || "Spinner.focusInputMap".equals(string))) {
            SynthContext synthContext2 = this.getContext(componentUI, jComponent);
            InputMap inputMap = (InputMap)synthContext2.getStyle().get(synthContext2, string);
            LookAndFeel.loadKeyBindings(inputMap, new Object[]{"meta X", "cut-to-clipboard", "meta C", "copy-to-clipboard", "meta V", "paste-from-clipboard", "meta A", "select-all"});
            if ("TextField.focusInputMap".equals(string) || "FormattedTextField.focusInputMap".equals(string) || "PasswordField.focusInputMap".equals(string) || "TextArea.focusInputMap".equals(string) || "TextPane.focusInputMap".equals(string) || "EditorPane.focusInputMap".equals(string)) {
                Object[] objectArray = this.asArray(this.getMacMap4JTextComponent());
                LookAndFeel.loadKeyBindings(inputMap, objectArray);
            }
            return inputMap;
        }
        if (this.isSynthUI(componentUI) && ("TextField.focusInputMap".equals(string) || "FormattedTextField.focusInputMap".equals(string) || "PasswordField.focusInputMap".equals(string) || "TextArea.focusInputMap".equals(string) || "TextPane.focusInputMap".equals(string) || "EditorPane.focusInputMap".equals(string))) {
            SynthContext synthContext3 = this.getContext(componentUI, jComponent);
            InputMap inputMap = (InputMap)synthContext3.getStyle().get(synthContext3, string);
            Object[] objectArray = this.asArray(this.getCustomMap4TextComponent());
            LookAndFeel.loadKeyBindings(inputMap, objectArray);
            return inputMap;
        }
        if ("Button.defaultButtonFollowsFocus".equals(string)) {
            return UIManager.getBoolean("Button.defaultButtonFollowsFocus");
        }
        if ("SplitPane.oneTouchButtonOffset".equals(string) && UIManager.getBoolean("Syntetica.splitPane.centerOneTouchButtons") && this.isSynthUI(componentUI)) {
            JSplitPane jSplitPane = (JSplitPane)jComponent;
            Insets insets = jSplitPane.getInsets();
            int n = 0;
            n = jSplitPane.getOrientation() == 0 ? jSplitPane.getWidth() - insets.left - insets.right : jSplitPane.getHeight() - insets.top - insets.bottom;
            SynthContext synthContext4 = this.getContext(componentUI, jComponent);
            int n2 = (Integer)synthContext4.getStyle().get(synthContext4, "SplitPane.oneTouchButtonSize");
            int n3 = jSplitPane.getDividerSize();
            return n / 2 - n2 - n3;
        }
        if ("OptionPane.buttonPadding".equals(string)) {
            return UIManager.get("OptionPane.buttonPadding");
        }
        if ("OptionPane.buttonOrientation".equals(string)) {
            return UIManager.get("OptionPane.buttonOrientation");
        }
        if ("ProgressBar.horizontalSize".equals(string)) {
            return SyntheticaLookAndFeel.getDim("ProgressBar.horizontalSize", jComponent);
        }
        if ("ProgressBar.vertictalSize".equals(string) || "ProgressBar.verticalSize".equals(string)) {
            return SyntheticaLookAndFeel.getDim("ProgressBar.verticalSize", jComponent);
        }
        if ("Slider.tickColor".equals(string) && !jComponent.isEnabled() && SyntheticaLookAndFeel.get("Slider.tickColor.disabled", jComponent) != null) {
            return SyntheticaLookAndFeel.get("Slider.tickColor.disabled", jComponent);
        }
        if ("Slider.tickColor".equals(string) && SyntheticaLookAndFeel.get("Slider.tickColor", jComponent) != null) {
            return SyntheticaLookAndFeel.get("Slider.tickColor", jComponent);
        }
        if ("TabbedPane.labelShift".equals(string)) {
            return SyntheticaLookAndFeel.getInt("TabbedPane.labelShift", jComponent, 1);
        }
        if ("TabbedPane.selectedLabelShift".equals(string)) {
            return SyntheticaLookAndFeel.getInt("TabbedPane.selectedLabelShift", jComponent, -1);
        }
        Object object = SyntheticaLookAndFeel.get(string, jComponent);
        if (object != null) {
            return object;
        }
        if (this.isSynthUI(componentUI) && (synthContext = this.getContext(componentUI, jComponent)) != null && synthContext.getStyle() != null) {
            Object object2 = synthContext.getStyle().get(synthContext, string);
            return object2;
        }
        return super.getDefault(jComponent, componentUI, string);
    }

    private boolean isSynthUI(Object object) {
        return synthUI.isAssignableFrom(object.getClass());
    }

    private SynthContext getContext(final Object object, final JComponent jComponent) {
        SynthContext synthContext = null;
        synthContext = JavaVersion.JAVA5 || JavaVersion.JAVA6 ? ((SynthUI)object).getContext(jComponent) : AccessController.doPrivileged(new PrivilegedAction<SynthContext>(){

            @Override
            public SynthContext run() {
                try {
                    Method method = object.getClass().getMethod("getContext", JComponent.class);
                    method.setAccessible(true);
                    return (SynthContext)method.invoke(object, jComponent);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        });
        return synthContext;
    }

    private Object[] asArray(Map<Object, Object> map) {
        Object[] objectArray = new Object[map.size() * 2];
        int n = 0;
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            objectArray[n++] = entry.getKey();
            objectArray[n++] = entry.getValue();
        }
        return objectArray;
    }

    private Map<Object, Object> getMacMap4JTextComponent() {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        hashMap.put("meta A", "select-all");
        hashMap.put("meta LEFT", "caret-begin-line");
        hashMap.put("meta KP_LEFT", "caret-begin-line");
        hashMap.put("meta RIGHT", "caret-end-line");
        hashMap.put("meta KP_RIGHT", "caret-end-line");
        hashMap.put("meta UP", "caret-begin");
        hashMap.put("meta KP_UP", "caret-begin");
        hashMap.put("meta DOWN", "caret-end");
        hashMap.put("meta KP_DOWN", "caret-end");
        hashMap.put("meta shift LEFT", "selection-begin-line");
        hashMap.put("meta shift KP_LEFT", "selection-begin-line");
        hashMap.put("meta shift RIGHT", "selection-end-line");
        hashMap.put("meta shift KP_RIGHT", "selection-end-line");
        hashMap.put("meta shift UP", "selection-begin");
        hashMap.put("meta shift KP_UP", "selection-begin");
        hashMap.put("meta shift DOWN", "selection-end");
        hashMap.put("meta shift KP_DOWN", "selection-end");
        hashMap.put("meta shift PAGE_UP", "selection-page-up");
        hashMap.put("meta shift PAGE_DOWN", "selection-page-down");
        hashMap.put("meta BACK_SLASH", "unselect");
        hashMap.put("meta T", "next-link-action");
        hashMap.put("meta shift T", "previous-link-action");
        hashMap.put("meta SPACE", "activate-link-action");
        hashMap.put("ctrl H", "delete-previous");
        hashMap.put("ctrl D", "delete-next");
        hashMap.put("ctrl W", "delete-previous-word");
        hashMap.put("ctrl F", "caret-forward");
        hashMap.put("ctrl B", "caret-backward");
        hashMap.put("alt RIGHT", "caret-next-word");
        hashMap.put("alt KP_RIGHT", "caret-next-word");
        hashMap.put("alt LEFT", "caret-previous-word");
        hashMap.put("alt KP_LEFT", "caret-previous-word");
        hashMap.put("alt DELETE", "delete-next-word");
        hashMap.put("alt BACK_SPACE", "delete-previous-word");
        hashMap.put("shift alt RIGHT", "selection-next-word");
        hashMap.put("shift alt KP_RIGHT", "selection-next-word");
        hashMap.put("shift alt LEFT", "selection-previous-word");
        hashMap.put("shift alt KP_LEFT", "selection-previous-word");
        Map map = (Map)UIManager.get("Synthetica.textComponent.macFocusInputMap");
        if (map != null) {
            hashMap.putAll(map);
        }
        return hashMap;
    }

    private Map<Object, Object> getCustomMap4TextComponent() {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Map map = (Map)UIManager.get("Synthetica.textComponent.focusInputMap");
        if (map != null) {
            hashMap.putAll(map);
        }
        return hashMap;
    }
}

